/****************************************************************************
**
**	File Name   : HAL.h
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : OS-specific header file for RCTSGM.  This establishes a 
**					"Hardware Abstraction Layer", i.e., all OS specific
**					information should be included here.
**
**	Change Log	: $Header: /rctsgm/inc/HAL.h 4     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#ifndef	__H_HAL
	#define __H_HAL

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif
/*	----------------------------------------------------------------------
	OS-specific headers
	----------------------------------------------------------------------	*/
#pragma warning(disable: 4201 4514)

#define OEM_RESOURCE
#define WIN32_LEAN_AND_MEAN
#define NOSERVICE
#define NOMCX
#define NOIME
#define NOSOUND
#define NOCOMM
#define NOKANJI
#define NORPC
#define NOPROXYSTUB
#define NOIMAGE
#define NOTAPE

#include <windows.h>
#include <limits.h>

#pragma warning(default: 4201)
/*	----------------------------------------------------------------------
	Global Data Primitives
	----------------------------------------------------------------------	*/
/*
**	Text -- an 8-bit value representing a single letter (char)
*/
typedef TCHAR				Text;
/*
**	[u]int8 -- an 8-bit value, better known to millions as a "byte".
*/
#ifndef	int8
	typedef char			int8;
#endif
#ifndef	uint8
	typedef unsigned char	uint8;
#endif

const int8					INT8_MAX = SCHAR_MAX;
const int8					INT8_MIN = SCHAR_MIN;
const uint8					UINT8_MAX = UCHAR_MAX;
/*
**	[u]int16 -- an 16-bit value, aka a "word".
*/
#ifndef	int16
	typedef short			int16;
#endif
#ifndef	uint16
	typedef unsigned short	uint16;
#endif

const int16					INT16_MAX = SHRT_MAX;
const int16					INT16_MIN = SHRT_MIN;
const uint16				UINT16_MAX = USHRT_MAX;
/*
**	[u]int32 -- an 32-bit value, or a "double word".
*/
#ifndef	int32
	typedef long			int32;
#endif
#ifndef	uint32
	typedef unsigned long	uint32;
#endif

const int32					INT32_MAX = LONG_MAX;
const int32					INT32_MIN = LONG_MIN;
const uint32				UINT32_MAX = ULONG_MAX;
/*
**	Other stuff
*/
typedef void *				Ptr;
typedef uint8 const *		DataPtr;
typedef Text *				StringPtr;
typedef const Text * const	TextPtr;	// non-changeable (fixed literals)
/*	----------------------------------------------------------------------
	Global Macros
	----------------------------------------------------------------------	*/
#define	GOOD_HND(h)		(NULL != HANDLE(h) && INVALID_HANDLE_VALUE != HANDLE(h))
/*
**	xxx_PTR()/xxx_HND() simplify testing of valid pointers
*/
#define GOOD_PTR(p)		(NULL != LPVOID(p))
#define NULL_PTR(p)		(NULL == LPVOID(p))
/*
**	MEM_xxx() -- wrappers around memory functions
*/
#define	MEM_CMP(x,y,n)	memcmp((x),(y),(n))
#define	MEM_COPY(d,s,n)	::CopyMemory((d),(s),(n))
#define	MEM_FILL(d,n,c)	::FillMemory((d),(n),(c))
#define	MEM_ZERO(d,n)	::ZeroMemory((d), (n))
/*
**	STR_xxx() macros -- wrap the RTL string functions so that they can be 
**	quickly and easily changed.  Very helpful for UNICODE apps...
*/
#define	STR_CAT			strncat
#define	STR_CHR			strchr
#define	STR_COPY		strncpy
#define	STR_EMPTY(p)	(NULL_PTR(p) || *(p) == '\0')
#define	STR_LEN			strlen
#define	STR_RCHR		strrchr
#define STR_SAFE(p)		(GOOD_PTR(p) ? (p) : kStrEmpty)
#define	STR_SPRINTF		_snprintf
/*	----------------------------------------------------------------------
	Global Classes
	----------------------------------------------------------------------	*/
/*
**	noncopyable -- a mix-in class that prevents an object from being copied.
**		The copy CTOR and assignment operator are defined in the interface 
**		(but never actually implemented) because we want the linker to barf 
**		if they are used.
*/
class noncopyable 
	{
private:
						noncopyable(const noncopyable &);	// copy CTOR
	const noncopyable &	operator=(const noncopyable &);		// assignment operator
protected:
						noncopyable() 
							{ /* STUB FUNCTION */ }
	virtual				~noncopyable()
							{ /* STUB FUNCTION */ }
    };

#endif	// __H_HAL
/****************************************************************************
**
**	End of hal.h
**
****************************************************************************/
