/****************************************************************************
**
**	File Name   : SV6Items.cpp
**
**	Project     : RCTSGM
**
**	Last Updated: Mon 10 Mar '03
**	          by: ,,,^..^,,,
**
**	Description : Implementation of the CSV6Items class.
**
**	Change Log	: $Header: /rctsgm/src/SV6Items.cpp 2     3/10/03 11:50a Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Tue 04 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**
****************************************************************************/
#include "rctsgm.h"
#include "rctfile.h"

#undef	THIS_FILE
const TextPtr			THIS_FILE = __FILE__;
/*	----------------------------------------------------------------------
	Global (external) Constants/Variables
	----------------------------------------------------------------------	*/

/*	----------------------------------------------------------------------
	Local Function Prototypes
	----------------------------------------------------------------------	*/

/****************************************************************************
**
**	CSV6Items::CSV6Items() -- [CTOR]
**
*/
CSV6Items::CSV6Items()
{
ASSERT( sizeof(SV6Item) == 16 );
}	/* end of CSV6Items::CSV6Items() */
/****************************************************************************
**
**	CSV6Items::~CSV6Items() -- [DTOR]
**
*/
CSV6Items::~CSV6Items()
{
// STUB FUNCTION
}	/* end of CSV6Items::~CSV6Items() */
/****************************************************************************
**
**	CSV6Items::Read() -- reads in a chunk of RCT data
**
*/
bool							// true if read successfully, false otherwise
CSV6Items::Read(
	int32		nIndex,			// chunk #
	DataPtr		pData,			// ptr to start of chunk
	uint32		dwDataLen,		// data bytes available
	uint32 &	dwRead)			// [out] size of chunk
{
m_nIndex = nIndex;		ASSERT(nIndex == 2);
	
if (!readChunk(pData, dwDataLen, dwRead))
	return false;

if (m_dwDataLen != (sizeof(SV6Item) * kItemCount))
	{
	Display(true,
			"Chunk #%d: invalid item data length (%s bytes).\n",
			m_nIndex, StrNum(m_dwDataLen));
	return false;
	}

return true;
}	/* end of CSV6Items::Read() */
/****************************************************************************
**
**	End of SV6Items.cpp
**
****************************************************************************/
