/****************************************************************************
**
**	File Name   : SV6Items.h
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Class interface to the SV6Items class.
**						
**
**	Change Log	: $Header: /rctsgm/inc/SV6Items.h 3     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 ========	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#ifndef	__H_SV6ITEMS
	#define __H_SV6ITEMS

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif

#include "SV6Chunk.h"
/*	----------------------------------------------------------------------
	RCT2 Data Constants/Structures

	Each *.SV6 file contains a total of 721 items:
			128	rides
			252	small scenery
			128	scenery
			128	walls
			 32	banners
			 16	paths
			 15	path bits
			 19	scenery sets
			  1	park entrance
			  1	water
			  1 "stex" dat file to use 
	----------------------------------------------------------------------	*/
const uint32		kItemCount = 721;
const uint32		kSV6ItemNameLen = 8;

#pragma pack(push, 1)

typedef struct
	{
	uint32			dwFlags;
	uint8			xName[kSV6ItemNameLen];
	uint32			dwCRC;
	}	SV6Item;

typedef SV6Item *	SV6ItemPtr;

#pragma pack(pop)
/*	----------------------------------------------------------------------
	CSV6Items Class Interface -- see SV6Items.cpp for implementation
	----------------------------------------------------------------------	*/
class CSV6Items : public Chunk
	{
/*
**	Variables
*/

/*
**	Methods
*/
public:
	bool				Read(int32, DataPtr, uint32, uint32 &);
//
//	GETTERS/SETTERS
//

	uint32				GetItemCount(void) const
							{ return kItemCount; }
	SV6ItemPtr			GetNthItem(uint32) const;
//
//	CTOR/DTOR
//
						CSV6Items();
	virtual				~CSV6Items();
	};

#endif	// __H_SV6ITEMS
/****************************************************************************
**
**	End of SV6Items.h
**
****************************************************************************/
