/****************************************************************************
**
**	File Name   : SV6Objects.h
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Class interface to the CSV6Objects class
**						
**
**	Change Log	: $Header: /rctsgm/inc/SV6Objects.h 4     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 ========	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#ifndef	__H_SV6OBJECTS
	#define __H_SV6OBJECTS

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif

#include "SV6Chunk.h"
/*	----------------------------------------------------------------------
	RCT2 Data Constants/Structures
	----------------------------------------------------------------------	*/
const uint32		kSV6ObjectNameLen = 8;

#pragma pack(push, 1)

typedef struct
	{
	uint32			dwFlags;
	uint8			xName[kSV6ObjectNameLen];
	uint32			dwCRC;
	SV6ChunkInfo	chunk;
	}	SV6ObjHeader;

typedef SV6ObjHeader *		SV6ObjHeaderPtr;

#pragma pack(pop)
/*	----------------------------------------------------------------------
	CSV6Objects Class -- see SV6Objects.cpp for implementation
	----------------------------------------------------------------------	*/
class CSV6Objects : public Chunk
	{
/*
**	Variables
*/
protected:
	uint16				m_wObjCount;
/*
**	Methods
*/
public:
	bool				Apply(Changes const &);
	void				Dump(Options const &) const;

	bool				Read(int32, uint16, DataPtr, uint32, uint32 &);
	bool				Write(FILE *, uint32 &, uint32 &);
//
//	GETTERS/SETTERS
//
	uint16				GetObjectCount(void) const
							{ return m_wObjCount; }
	void				SetObjectCount(uint16 wCount) 
							{ m_wObjCount = wCount; }
//
//	CTOR/DTOR
//
						CSV6Objects();
	virtual				~CSV6Objects();
	};

#endif	// __H_SV6OBJECTS
/****************************************************************************
**
**	End of SV6Object.h
**
****************************************************************************/
