/****************************************************************************
**
**	File Name   : dialog.cpp
**
**	Project     : RCTSGM
**
**	Last Updated: Thu 29 May '03
**	          by: ,,,^..^,,,
**
**	Description : Manages a dialog so that dain-bramaged users don't have to
**					learn how to use a command line program.
**
**	Change Log	: $Header: $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Thu 29 May '03		1.10	Initial design & coding
**
****************************************************************************/
#include "rctsgm.h"
#include "SV6Data.h"
#include "SV6Flags.h"
#include "resource.h"

#include <commdlg.h>
/*	----------------------------------------------------------------------
	Global Variables -- declared in main.cpp
	----------------------------------------------------------------------	*/
extern Changes			theChanges;
extern Options			theOptions;
/*	----------------------------------------------------------------------
	Local Macros
	----------------------------------------------------------------------	*/

/*	----------------------------------------------------------------------
	Local Function Prototypes
	----------------------------------------------------------------------	*/
static void				browseSV6(HWND);
static void				resetAllItems(HWND);
static bool				validateData(HWND);

static inline void		enableItem(HWND hwnd, bool bOn)
							{
							if (GOOD_HND(hwnd))
								::EnableWindow(hwnd, (bOn ? TRUE : FALSE));
							}
						
static inline bool		getCheckbox(HWND hwnd)
							{
							return (GOOD_HND(hwnd) &&
									::SendMessage(hwnd, BM_GETCHECK, 0, 0) == BST_CHECKED);
							}

static inline void		setCheckbox(HWND hwnd, bool bVar)
							{
							if (GOOD_HND(hwnd))
								::SendMessage(hwnd, BM_SETCHECK, (bVar ? BST_CHECKED : BST_UNCHECKED), 0);
							}

static inline bool		getNumber(HWND hwnd, uint32 & uVar)
							{
							TCHAR	szNum[40];
								
							if (GOOD_HND(hwnd) &&
								::GetWindowText(hwnd, szNum, 40) > 0)
								{
								uVar = strtoul(szNum, NULL, 10);
								return true;
								}
								
							return false;
							}
						
static inline void		setNumber(HWND hwnd, const uint32 uVar)
							{
							if (GOOD_HND(hwnd))
								{
								TCHAR	szNum[40];
								::SetWindowText(hwnd, _ultoa(uVar, szNum, 10));
								}
							}

static inline int		getString(HWND hwnd, LPTSTR pstr, const int nMax)
							{
							int		nLen = 0;
							
							::ZeroMemory(pstr, sizeof(TCHAR) * nMax);
							if (GOOD_HND(hwnd))
								nLen = ::GetWindowText(hwnd, pstr, nMax);

							return nLen;
							}
						
static inline void		setString(HWND hwnd, LPCTSTR pstr)
							{
							if (GOOD_HND(hwnd))
								::SetWindowText(hwnd, pstr);
							}
/****************************************************************************
**
**	fnStartupDlgProc() -- dialog procedure for the IDD_STARTUP dialog
**	
*/
INT_PTR CALLBACK 
fnStartupDlgProc(
	HWND	hwndDlg,
    UINT	uMsg,
    WPARAM	wParam,
    LPARAM	lParam)
{
BOOL	bHandled = FALSE;

switch (uMsg) 
	{
	case WM_INITDIALOG:
		(void) ::SetWindowText(hwndDlg, kStrTitle);
		return true;
		
	case WM_COMMAND:
		if (HIWORD(wParam) == EN_CHANGE && 
			LOWORD(wParam) == IDC_SV6_FILE) 
            {
			bool bSV6 = (getString(	::GetDlgItem(hwndDlg, IDC_SV6_FILE), 
									theOptions.szMask, MAX_PATH) > 0);
			enableItem(::GetDlgItem(hwndDlg, IDOK), bSV6);
			enableItem(::GetDlgItem(hwndDlg, ID_REPAIR), bSV6);
            }
            
  		switch (wParam)
			{
			case IDCANCEL:
				::EndDialog(hwndDlg, wParam);
				break;
			
			case IDOK:
				if (validateData(hwndDlg))
					::EndDialog(hwndDlg, IDOK);
				break;
				
			case ID_REPAIR:
				if (validateData(hwndDlg))
					{
					theChanges.bFix = true;
					::EndDialog(hwndDlg, IDOK);
					}
				break;
				
			case ID_HUMBLE:
				bHandled = TRUE;
				
				resetAllItems(hwndDlg);
				
				setString(::GetDlgItem(hwndDlg, IDC_DATE), "01-03-01");
				setNumber(::GetDlgItem(hwndDlg, IDC_CASH), kMaxCash);
				setNumber(::GetDlgItem(hwndDlg, IDC_LOAN), kMinLoan);
				setNumber(::GetDlgItem(hwndDlg, IDC_LOAN_MAX), kMaxLoan);
				setNumber(::GetDlgItem(hwndDlg, IDC_LOAN_RATE), kMinIntRate);
				
				setCheckbox(::GetDlgItem(hwndDlg, IDC_RIDES_FIXED), true);
				setCheckbox(::GetDlgItem(hwndDlg, IDC_RIDES_PLAIN), true);
				
				setCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_HAPPY), true);
				setCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_ROBBED), true);
				setCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_STARVED), true);
				
				setCheckbox(::GetDlgItem(hwndDlg, IDC_MAKE_TIDY), true);
				break;
			
			case ID_RESET:
				bHandled = TRUE;
				resetAllItems(hwndDlg);
				break;
				
			case ID_BROWSE:
				bHandled = TRUE;
				browseSV6(hwndDlg);
				break;
			
			case IDC_DATE_RESET:
				setString(::GetDlgItem(hwndDlg, IDC_DATE), "01-03-01");
				break;

			case IDC_MAKE_FREE:
				{
				bool	bCash = !getCheckbox(::GetDlgItem(hwndDlg, IDC_MAKE_FREE));
				
				enableItem(::GetDlgItem(hwndDlg, IDC_CASH), bCash);
				enableItem(::GetDlgItem(hwndDlg, IDC_LOAN), bCash);
				enableItem(::GetDlgItem(hwndDlg, IDC_LOAN_MAX), bCash);
				enableItem(::GetDlgItem(hwndDlg, IDC_LOAN_RATE), bCash);
				enableItem(::GetDlgItem(hwndDlg, IDC_PEEP_CASH), bCash);
				}
				break;
			}
		break;
	}

return bHandled;
}	/* end of fnStartupDlgProc() */
/****************************************************************************
**
**	DoStartupDialog() -- don't ask.
**
*/
int32							// NO_ERROR on success, error code otherwise
DoStartupDialog(void)
{
int		nRC = (int) ::DialogBox(::GetModuleHandle(NULL), 
								MAKEINTRESOURCE(IDD_STARTUP),
								GetWindowHandle(), 
								fnStartupDlgProc);

return (nRC == IDOK) ? NO_ERROR : ERROR_CANCELLED;
}	/* end of DoStartupDialog() */
/****************************************************************************
**
**	browseSV6() -- browses for an *.SV6 file
**
*/
static void
browseSV6(
	HWND	hwndOwner)
{
HWND	hwnd = GetDlgItem(hwndOwner, IDC_SV6_FILE);

if (GOOD_HND(hwnd))
	{
	OPENFILENAME	ofn;
	TCHAR			szFile[MAX_PATH+1];

	::ZeroMemory(szFile, sizeof(szFile));
	::GetWindowText(hwnd, szFile, MAX_PATH);
	//
	//	Initialize OPENFILENAME
	//
	::ZeroMemory(&ofn, sizeof(ofn));
	
	ofn.lStructSize		= sizeof(ofn);
	ofn.hwndOwner		= hwndOwner;
	ofn.lpstrFile		= szFile;
	ofn.nMaxFile		= MAX_PATH;
	ofn.lpstrFilter		= "RCT2 Saved Games\0*.SV6\0All\0*.*\0";
	ofn.nFilterIndex	= 1;
	ofn.lpstrFileTitle	= NULL;
	ofn.nMaxFileTitle	= 0;
	ofn.lpstrInitialDir	= NULL;
	ofn.Flags			= OFN_EXPLORER|OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST;

	if (::GetOpenFileName(&ofn)) 
		::SetWindowText(hwnd, ofn.lpstrFile);
	}
}	/* end of browseSV6() */
/****************************************************************************
**
**	resetAllItems() -- reset all controls to their original (empty) state.
**
*/
static void
resetAllItems(
	HWND	hwndDlg)
{
enableItem(::GetDlgItem(hwndDlg, IDC_CASH), true);
enableItem(::GetDlgItem(hwndDlg, IDC_LOAN), true);
enableItem(::GetDlgItem(hwndDlg, IDC_LOAN_MAX), true);
enableItem(::GetDlgItem(hwndDlg, IDC_LOAN_RATE), true);
enableItem(::GetDlgItem(hwndDlg, IDC_PEEP_CASH), true);

setCheckbox(::GetDlgItem(hwndDlg, IDC_VERBOSE), false);

setString(::GetDlgItem(hwndDlg, IDC_DATE), kStrEmpty);
setString(::GetDlgItem(hwndDlg, IDC_CASH), kStrEmpty);
setString(::GetDlgItem(hwndDlg, IDC_LOAN), kStrEmpty);
setString(::GetDlgItem(hwndDlg, IDC_LOAN_MAX), kStrEmpty);
setString(::GetDlgItem(hwndDlg, IDC_LOAN_RATE), kStrEmpty);
setString(::GetDlgItem(hwndDlg, IDC_PEEP_CASH), kStrEmpty);

setCheckbox(::GetDlgItem(hwndDlg, IDC_MAKE_TIDY), false);
setCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_GONE), false);
setCheckbox(::GetDlgItem(hwndDlg, IDC_MAKE_FREE), false);

setCheckbox(::GetDlgItem(hwndDlg, IDC_RIDES_FIXED), false);
setCheckbox(::GetDlgItem(hwndDlg, IDC_RIDES_PLAIN), false);
setCheckbox(::GetDlgItem(hwndDlg, IDC_RIDES_QUIET), false);

setCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_BUFF), false);
setCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_HAPPY), false);
setCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_ROBBED), false);
setCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_STARVED), false);
}	/* end of resetAllItems() */
/****************************************************************************
**
**	validateData() -- read the data from the various controls into the global
**		theChanges structure.
**
*/
static bool
validateData(
	HWND	hwndDlg)
{
int32		nDay, 
			nMonth, 
			nYear;
uint32		uValue;
TCHAR		szTmp[kStrTmpLen+1];

::ZeroMemory(szTmp, sizeof(szTmp));

theOptions.bVerbose = getCheckbox(::GetDlgItem(hwndDlg, IDC_VERBOSE));
//
//	IDC_DATE
//
if (getString(::GetDlgItem(hwndDlg, IDC_DATE), szTmp, kStrTmpLen) > 0)
	{
	if (sscanf(szTmp, "%ld-%ld-%ld", &nDay, &nMonth, &nYear) == 3 &&
		CSV6Flags::IsValidDate(nDay, nMonth, nYear))
		{
		theChanges.SetDate.nDay		= nDay;
		theChanges.SetDate.nMonth	= nMonth;
		theChanges.SetDate.nYear	= nYear;
		}
	else
		{
		(void) ::MessageBox(GetWindowHandle(), 
							"Invalid date!", kStrTitle, 
							MB_OK|MB_ICONEXCLAMATION);
		return false;
		}
	}

theChanges.bMakeFree = getCheckbox(::GetDlgItem(hwndDlg, IDC_MAKE_FREE));

if (!theChanges.bMakeFree)	// only bother with these if money still matters
	{
	//
	//	IDC_CASH
	//
	if (getNumber(::GetDlgItem(hwndDlg, IDC_CASH), uValue))
		{
		if (uValue >= kMinCash && uValue <= kMaxCash)
			theChanges.dwCash = uValue + 1;
		else
			{
			(void) ::MessageBox(GetWindowHandle(), 
								"Invalid cash amount!", kStrTitle, 
								MB_OK|MB_ICONEXCLAMATION);
			return false;
			}
		}
	//
	//	IDC_LOAN
	//
	if (getNumber(::GetDlgItem(hwndDlg, IDC_LOAN), uValue))
		{
		if (uValue >= kMinLoan && uValue <= kMaxLoan)
			theChanges.dwLoan = uValue + 1;
		else
			{
			(void) ::MessageBox(GetWindowHandle(), 
								"Invalid loan amount!", kStrTitle, 
								MB_OK|MB_ICONEXCLAMATION);
			return false;
			}
		}
	//
	//	IDC_LOAN_MAX
	//
	if (getNumber(::GetDlgItem(hwndDlg, IDC_LOAN_MAX), uValue))
		{
		if (uValue >= kMinLoan && uValue <= kMaxLoan)
			theChanges.dwMaxLoan = uValue + 1;
		else
			{
			(void) ::MessageBox(GetWindowHandle(), 
								"Invalid maximum loan amount!", kStrTitle, 
								MB_OK|MB_ICONEXCLAMATION);
			return false;
			}
		}	
	//
	//	IDC_LOAN_RATE
	//
	if (getNumber(::GetDlgItem(hwndDlg, IDC_LOAN_RATE), uValue))
		{
		if (uValue >= kMinIntRate && uValue <= kMaxIntRate)
			theChanges.wIntRate = uint16(uValue) + 1;
		else
			{
			(void) ::MessageBox(GetWindowHandle(), 
								"Invalid interest rate!", kStrTitle, 
								MB_OK|MB_ICONEXCLAMATION);
			return false;
			}
		}	
	//	
	//	IDC_PEEP_CASH
	//
	if (getNumber(::GetDlgItem(hwndDlg, IDC_PEEP_CASH), uValue))
		{
		if (uValue >= kMinPeepCash && uValue <= kMaxPeepCash)
			theChanges.dwPeepCash = uValue + 1;
		else
			{
			(void) ::MessageBox(GetWindowHandle(), 
								"Invalid peep cash amount!", kStrTitle, 
								MB_OK|MB_ICONEXCLAMATION);
			return false;
			}
		}	
	}
//
//	IDC_PEEPS_*
//
theChanges.bPeepsBuff	= getCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_BUFF));				
theChanges.bPeepsHappy	= getCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_HAPPY));				
theChanges.bPeepsRobbed	= getCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_ROBBED));				
theChanges.bPeepsStarve	= getCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_STARVED));				
//
//	IDC_RIDES_*
//
theChanges.bRidesFixed	= getCheckbox(::GetDlgItem(hwndDlg, IDC_RIDES_FIXED));				
theChanges.bRidesPlain	= getCheckbox(::GetDlgItem(hwndDlg, IDC_RIDES_PLAIN));				
theChanges.bRidesQuiet	= getCheckbox(::GetDlgItem(hwndDlg, IDC_RIDES_QUIET));				
//
//	General
//
theChanges.bPeepsGone	= getCheckbox(::GetDlgItem(hwndDlg, IDC_PEEPS_GONE));				
theChanges.bMakeTidy	= getCheckbox(::GetDlgItem(hwndDlg, IDC_MAKE_TIDY));

return true;
}	/* end of validateData() */
/****************************************************************************
**
**	End of dialog.cpp
**
****************************************************************************/
