/****************************************************************************
**
**	File Name   : main.cpp
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Implementation of the RCTSGM application.
**
**	Change Log	: $Header: /rctsgm/src/main.cpp 5     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#include "rctsgm.h"
#include "rctfile.h"

#undef	THIS_FILE
const TextPtr		THIS_FILE = __FILE__;
/*	----------------------------------------------------------------------
	Global Constants/Variables
	----------------------------------------------------------------------	*/
Changes					theChanges = { 0 };
Options					theOptions = { 0 };

RCTFile					theFile;
/*	----------------------------------------------------------------------
	Local Definitions/Variables
	----------------------------------------------------------------------	*/

/****************************************************************************
**
**	main() -- entry point for the RCTSGM application.
**
*/
int
main(
	int		argc,
	char *	argv[])
{
uint32		dwErr;

if ((dwErr = ParseCmdLine(argc, argv)) != NO_ERROR)
	return dwErr; 
//
//	String the path off the mask
//
StringPtr	pszSlash;
Text		szPath[MAX_PATH+1];

MEM_ZERO(szPath, sizeof(szPath));
STR_COPY(szPath, theOptions.szMask, MAX_PATH);
pszSlash = STR_RCHR(szPath, '\\');
if (GOOD_PTR(pszSlash))
	pszSlash[1] = '\0';	// terminate after the last slash
else
	szPath[0] = '\0';	// clear the path string
//
//	Now start searching for matching files
//
WIN32_FIND_DATA	wfd;
HANDLE			hFind,
				hNewFile = NULL;

Display(false,
		"RCTSGM -- RCT2 Save Game Modifier v%s\n"
		"Brought to you by Humble Programmer (humble_programmer@yahoo.com)    ,,,^..^,,,\n\n",
		kStrVersion);

hFind = ::FindFirstFile(theOptions.szMask, &wfd);
if (GOOD_HND(hFind))
	{
	do
		{
		try
			{
			if (theFile.Open(szPath, wfd))
				{
				Display(true, 
					"File \"%s\" successfully read (%s bytes).\n", 
					theFile.GetFileName(), StrNum(theFile.GetFileSize()));

				theFile.Dump(theOptions);	//	dump everything

				if (theFile.Apply(theChanges) || theOptions.bExpand)
					{
					Text	szNewFile[MAX_PATH+1];

					MEM_ZERO(szNewFile, sizeof(szNewFile));
					(void) STR_SPRINTF(szNewFile, MAX_PATH, "%sNew %s",szPath, wfd.cFileName);
					//
					//	Now save the file out with a new name.
					//
					if (theFile.Write(szNewFile))
						{
						Display(true, 
							"File \"%s\" successfully written (%s bytes).\n", 
							theFile.GetFileName(), StrNum(theFile.GetFileSize()));
						}
					}
				}

			theFile.Close();
			Display(true, kStrNewLn);
			}		
		catch (uint32	dwErrThrown)
			{
			dwErr = dwErrThrown;
			Display(true, 
					"File \"%s\" failed with error #%lu.\n", 
					wfd.cFileName, dwErr);
			}

		}
	while (::FindNextFile(hFind, &wfd));

	theFile.Close();

	if (GOOD_HND(hNewFile) && ::CloseHandle(hNewFile))
		hNewFile = NULL;

	if (GOOD_HND(hFind) && ::FindClose(hFind))
		hFind = NULL;
	}
else
	{
	Display(true,
			"No files matching \"%s\" were found.\n", 
			theOptions.szMask);
	}

if (GOOD_PTR(theOptions.pLogFile))
	{
	(void) fclose(theOptions.pLogFile);
	theOptions.pLogFile = NULL;
	}

if (theOptions.bWaitAtExit)
	{
	::MessageBox(GetWindowHandle(), 
					"Press \"OK\" to close the output window", 
					kStrTitle, 
					MB_OK|MB_ICONASTERISK);
	}
return	dwErr; 
}	/* end of main() */
/****************************************************************************
**
**	Panic() -- global error handler
**
**	NOTES:
**		1.	If the error code is NO_ERROR, this function returns gracefully.
**			If the error code is non-zero, this function DOES NOT RETURN!
**
*/
void
Panic(
	uint32		dwErr,			// error code
	TextPtr		pstrFile,		// source file
	uint32		uLine)			// line in source file
{
if (dwErr != NO_ERROR)
	{
#ifdef	_DEBUG
	DebugLog(pstrFile, uLine, "PANIC 0x08%lX!\n", dwErr);
#endif

	Display(true, 
			"%s(%u): PANIC 0x08%lX!\n", 
			pstrFile, uLine, dwErr);

	if (GOOD_PTR(theOptions.pLogFile))
		{
		(void) fclose(theOptions.pLogFile);
		theOptions.pLogFile = NULL;
		}

	::ExitProcess( dwErr );	// all die now!
	}
}	/* end of Panic() */
/****************************************************************************
**
**	End of main.cpp
**
****************************************************************************/
