/****************************************************************************
**
**	File Name   : rctfile.h
**
**	Project     : RCTSGM
**
**	Last Updated: Thu 29 May '03
**	          by: ,,,^..^,,,
**
**	Description : Class interface to the RCTFile class
**
**	Change Log	: $Header: /rctsgm/inc/rctfile.h 4     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**	Thu 29 May '03		1.11	Fixed (embarassing) logic bug
**
****************************************************************************/
#ifndef	__H_RCTFILE
	#define __H_RCTFILE

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif

#include "SV6Header.h"
#include "SV6Flags.h"
#include "SV6Items.h"
#include "SV6Objects.h"
#include "SV6Map.h"
#include "SV6Data.h"
/*	----------------------------------------------------------------------
	RCTFile Class -- see rctfile.cpp for implementation
	----------------------------------------------------------------------	*/
class RCTFile : public noncopyable
	{
/*
**	Variables
*/
protected:
	CSV6Header			m_chunk_0;
	CSV6Objects			m_chunk_1;
	CSV6Items			m_chunk_2;
	CSV6Flags			m_chunk_3;
	CSV6Map				m_chunk_4;
	CSV6Data			m_chunk_5;

	uint32				m_dwFileBytes;
	Text				m_szFile[MAX_PATH+1];
/*
**	Methods
*/
protected:

public:
	void				Close();
	bool				Open(TextPtr, WIN32_FIND_DATA const &);
	bool				Write(TextPtr);

	static bool			ConvertAbsMonth(uint16, int32 &, int32 &);
//
//	INLINES
//
	bool				Apply(Changes const & ch)
							{
							(void) m_chunk_0.Apply(ch);
							(void) m_chunk_1.Apply(ch);
							(void) m_chunk_2.Apply(ch);
							(void) m_chunk_3.Apply(ch);
							(void) m_chunk_4.Apply(ch);
							(void) m_chunk_5.Apply(ch);
							
							return (m_chunk_0.IsDirty() ||
									m_chunk_1.IsDirty() ||
									m_chunk_2.IsDirty() ||
									m_chunk_3.IsDirty() ||
									m_chunk_4.IsDirty() ||
									m_chunk_5.IsDirty());
							}

	void				Dump(Options  const & opt) const
							{
							m_chunk_0.Dump(opt);
							m_chunk_1.Dump(opt);
							m_chunk_2.Dump(opt);
							m_chunk_3.Dump(opt);
							m_chunk_4.Dump(opt);
							m_chunk_5.Dump(opt);
							}

	bool				IsDirty(void) const
							{
							return (m_chunk_0.IsDirty() ||
									m_chunk_1.IsDirty() ||
									m_chunk_2.IsDirty() ||
									m_chunk_3.IsDirty() ||
									m_chunk_4.IsDirty() ||
									m_chunk_5.IsDirty());
							}
//
//	GETTERS/SETTERS
//
	uint16				GetCustomObjectCount(void) const
							{ return m_chunk_0.GetCustomObjectCount(); }

	uint16				GetAbsMonth(void) const
							{ return m_chunk_3.GetAbsMonth(); }

	DataPtr				GetStringMap(void) const
							{ return m_chunk_5.GetRawData(0x27453C); }

	CSV6Header const *	GetHeader(void) const
							{ return &m_chunk_0; }
	CSV6Objects	const *	GetObjects(void) const
							{ return &m_chunk_1; }
	CSV6Items const *	GetItems(void) const
							{ return &m_chunk_2; }
	CSV6Flags const *	GetFlags(void) const
							{ return &m_chunk_3; }
	CSV6Map const *		GetMap(void) const
							{ return &m_chunk_4; }
	CSV6Data const *	GetData(void) const
							{ return &m_chunk_5; }

	TextPtr				GetFileName(void) const
							{ return m_szFile; }
	uint32				GetFileSize(void) const	
							{ return m_dwFileBytes; }
//
//	CTOR/DTOR
//
						RCTFile();
	virtual				~RCTFile();
	};

#endif	// __H_RCTFILE
/****************************************************************************
**
**	End of rctfile.h
**
****************************************************************************/
