/****************************************************************************
**
**	File Name   : rctsgm.h
**
**	Project     : RCTSGM
**
**	Last Updated: Thu 29 May '03
**	          by: ,,,^..^,,,
**
**	Description : Main header file for the RCTSGM application
**
**	Change Log	: $Header: /rctsgm/inc/rctsgm.h 9     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Fri 07 Mar '03		1.00	Initial design & coding
**	Wed 12 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**	Wed 28 May '03		1.10	Added startup dialog
**	Thu 29 May '03		1.11	Fixed (embarassing) logic bug
**
****************************************************************************/
#ifndef	__H_RCTSGM
	#define __H_RCTSGM

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif

#include "HAL.h"

#include <stdio.h>
#include <stdlib.h>
/*	----------------------------------------------------------------------
	Global Data Constants/Structures
	----------------------------------------------------------------------	*/
const int32				kMaxOutputWidth	= MAX_PATH;

const TextPtr			kStrEmpty		= "";
const TextPtr			kStrNewLn		= "\n";
const int32				kStrTmpLen		= 127;
const TextPtr			kStrTitle		= "RCTSGM v1.12";
const TextPtr			kStrVersion		= "1.12";
/*
**	NOTE:  the Changes structure is used to make changes to the RCTFile.  All
**			of the values use "zero" to indicate no change, so 1 is added to
**			individual values.  For example, to give each peep $250 you would
**			set the dwPeepCash field to 250 + 1 or 251.
*/
struct Changes
	{
	bool			bFix,				// try to "fix" all corrupt data
					bMakeFree,			// turn off cash management
					bMakeMoney,			// make park and ride fees modifiable
					bMakeTidy,			// clean up all the trash
					bPeepsBuff,			// make all the peeps buff
					bPeepsGone,			// make all the peeps disappear
					bPeepsHappy,		// make all the peeps happy
					bPeepsRobbed,		// take away all peep purchases
					bPeepsStarve,		// make peep hungry & thirsty
					bRidesFixed,		// make everything "like new"
					bRidesPlain,		// make all rides "plain"
					bRidesQuiet;		// turn off all music
	uint16			wIntRate;			// interest rate
	uint16			wParkRating;		// park rating
	uint32			dwCash;				// cash amount (in dollars)
	uint32			dwLoan;				// loan amount (in dollars)
	uint32			dwMaxLoan;			// maximum loan amount (in dollars)
	uint32			dwPeepCash;			// give each peep cash (in dollars)
	struct
		{
		int32	nDay;
		int32	nMonth;
		int32	nYear;
		}			SetDate;			// new date
	};	

struct Options
	{
	bool			bDumpInfo,				// true to dump misc. information
					bDumpMap,				// true to dump map information
					bDumpObjects,			// true to dump objects
					bDumpRides,				// true to dump rides
					bDumpSprites,			// true to dump sprites
					bExpand,				// true to expand the source .SV6 file
					bQuiet,					// true for quiet mode
					bVerbose,				// true for maximum verbosity
					bWaitAtExit;			// true to wait before closing window
	int32			nOutputWidth;			// width of output
	FILE *			pLogFile;				// handle to log file
	Text			szMask[MAX_PATH+1];		// file mask
	};
/*	----------------------------------------------------------------------
	Global Macros
	----------------------------------------------------------------------	*/
#define	KB(n)			((n) << 10)
#define MB(n)			((n) << 20)
#define	GB(n)			((n) << 30)
/*
**	ARRAY_DIM() returns the # of elements in an array.
*/
#define	ARRAY_DIM(x)	(sizeof(x) / sizeof((x)[0]))
/*
**	MAKE_PTR(cast, ptr, count) simplifies ptr math by adding "count" to
**	the "ptr", and then casting the new value as a "cast".
*/
#define	MAKE_PTR(c,p,n)	reinterpret_cast<c>(SIZE_T(p)+SIZE_T(n))
/*
**	ROTx() macros rotate a given value left or right by a specified number of
**	bits.
*/
#define ROTR(x,y,b)		(((x)>>(y&((b)-1))) | ((x)<<((b)-(y&((b)-1)))))
/*
**	Error handling macros, all of which eventually resolve to a call to
**	the Panic() function.
*/
#define	PANIC(e)		Panic((e), THIS_FILE, __LINE__)

#define	PANIC_IF(x,e)	{ if (x) PANIC(e); }
#define	API_PANIC_IF(x)	{ if (x) PANIC(::GetLastError()); }
#define PANIC_IF_NULL(p) { if (NULL_PTR(p)) PANIC(ERROR_INVALID_DATA); }
/*
**	Debug macros
*/
#ifdef	_DEBUG
	void						DebugLog(TextPtr, uint32, TextPtr, ...);

#	define	ASSERT(x)			{ if (!(x)) PANIC(ERROR_GEN_FAILURE); }
#	define	ASSERT_PTR(p,n)		ASSERT(GOOD_PTR(p) && !::IsBadWritePtr(LPVOID(p),(n)))

#	define	DEBUG_ONLY(x)		x	

#	define	DEBUG_LOG(a)		DebugLog(THIS_FILE, __LINE__, (a))
#	define	DEBUG_LOG1(a,b)		DebugLog(THIS_FILE, __LINE__, (a),(b))
#	define	DEBUG_LOG2(a,b,c)	DebugLog(THIS_FILE, __LINE__, (a),(b),(c))
#	define	DEBUG_LOG3(a,b,c,d)	DebugLog(THIS_FILE, __LINE__, (a),(b),(c),(d))
#else
#	define	NOTHING				((void)0)

#	define	ASSERT(x)			NOTHING
#	define	ASSERT_PTR(p,n)		NOTHING

#	define	DEBUG_ONLY(x)		NOTHING

#	define	DEBUG_LOG(a)		NOTHING
#	define	DEBUG_LOG1(a,b)		NOTHING
#	define	DEBUG_LOG2(a,b,c)	NOTHING
#	define	DEBUG_LOG3(a,b,c,d)	NOTHING
#endif
/*	----------------------------------------------------------------------
	Global Function Prototypes
	----------------------------------------------------------------------	*/
/*
**	dialog.cpp
*/
int32					DoStartupDialog(void);
/*
**	main.cpp
*/
void					Panic(uint32, TextPtr, uint32);
/*
**	startup.cpp
*/
uint32					ParseCmdLine(int32, const StringPtr []);
/*
**	utility.cpp
*/
void					Display(bool, TextPtr, ...);
void					DisplayBar(bool, Text, int32);
void					DisplayHex(bool, uint8 const *, uint32);

HWND					GetWindowHandle(void);

int32					StrCmpPartial(TextPtr, TextPtr);

StringPtr				StrCash(int32, int32 nDiv = 1);
StringPtr				StrDate(uint16);
StringPtr				StrDate(int32, int32, int32);
StringPtr				StrNum(int32, int32 nDiv = 1, uint32 uDecimals = 0);

#endif	// __H_RCTSGM
/****************************************************************************
**
**	End of rctsgm.h
**
****************************************************************************/
