/****************************************************************************
**
**	File Name   : SV6Chunk.h
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Class interface to the Chunk superclass.
**
**	Change Log	: $Header: /rctsgm/inc/SV6Chunk.h 4     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 ========	======
**	Tue 04 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#ifndef	__H_SV6CHUNK
	#define __H_SV6CHUNK

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif
/*	----------------------------------------------------------------------
	RCT2 Data Constants/Structures
	----------------------------------------------------------------------	*/
#pragma pack(push, 1)

typedef struct
	{
	uint8		xCompression;
	uint32		dwChunkSize;
	}	SV6ChunkInfo;

typedef SV6ChunkInfo *	SV6ChunkInfoPtr;

#pragma pack(pop)
/*	----------------------------------------------------------------------
	Chunk Class -- see SV6Chunk.cpp for implementation
	----------------------------------------------------------------------	*/
class Chunk : public noncopyable
	{
/*
**	Variables
*/
protected:
	bool				m_bDirty;
	int32				m_nIndex;
	uint32				m_dwDataLen;
	uint8 *				m_pRawData;
	SV6ChunkInfo		m_info;
/*
**	Methods
*/
protected:
	void				allocateData(uint32);
	uint32				compress(uint8 &, DataPtr, uint32);
	uint32				decompress(uint8, DataPtr, uint32);
	bool				readChunk(DataPtr, uint32, uint32 &);
	bool				writeChunk(FILE *, uint32 &, uint32 &);
public:
	virtual bool		Apply(Changes const &) 
							{ return false; }
	virtual void		Destroy(void)
							{ allocateData(0); }
	virtual void		Dump(Options const &) const
							{ /* STUB FUNCTION */ }
	virtual bool		Read(int32, DataPtr pData, uint32 dwLen, uint32 & dwRead)
							{ return readChunk(pData, dwLen, dwRead); }
	virtual bool		Write(FILE * pfOut, uint32 & dwBytes, uint32 & dwCRC)
							{ return writeChunk(pfOut, dwBytes, dwCRC); }
//
//	INLINES
//
	bool				IsDirty(void) const
							{ return m_bDirty; }
//
//	GETTERS/SETTERS
//
	DataPtr				GetRawData(uint32 dwOffset = 0) const
							{ return (GOOD_PTR(m_pRawData) && dwOffset < m_dwDataLen) ? &m_pRawData[dwOffset] : NULL; }
//
//	CTOR/DTOR
//
						Chunk();
	virtual				~Chunk();
	};

#endif	// __H_SV6CHUNK
/****************************************************************************
**
**	End of SV6Chunk.h
**
****************************************************************************/
