/****************************************************************************
**
**	File Name   : SV6Data.h
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Class interface to the CSV6Data class.
**						
**
**	Change Log	: $Header: /rctsgm/inc/SV6Data.h 7     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#ifndef	__H_SV6DATA
	#define __H_SV6DATA

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif

#include "SV6Chunk.h"
#include "SV6Ride.h"
#include "SV6Sprite.h"
/*	----------------------------------------------------------------------
	RCT2 Data Constants/Structures
	----------------------------------------------------------------------	*/
const int32				kMaxCash		= 10000000L;	// ten million
const int32				kMinCash		= 0L;

const int32				kMaxIntRate		= UCHAR_MAX;
const int32				kMinIntRate		= 0L;

const int32				kMaxLoan		= 5000000L;		// five million
const int32				kMinLoan		= 0L;

const int32				kMaxPeepCash	= 500L;
const int32				kMinPeepCash	= 0L;

const int32				kMaxRating		= 999L;
const int32				kMinRating		= 0L;
/*
**	SV6Sprite data structure -- this data structure must be the same length
**	as the structure in the file data.
*/
const uint32			kRideCount		= 255;
const uint32			kSpriteCount	= 10000;	// yup...ten thousand

#pragma pack(push, 1)

typedef struct
	{												// Byte Offset
	uint8				unknown_01[4];				// 0x000000
	SV6Sprite			sprites[kSpriteCount];		// 0x000004
	uint16				wNextSprite;				// 0x271004
	uint16				wVehicleSprite;				// 0x271006
	uint16				wPersonSprite;				// 0x271008
	uint16				wFlyerSprite;				// 0x27100A
	uint16				wTrashSprite;				// 0x27100C
	uint16				wOversizedSprite;			// 0x27100E
	uint16				wSpritesAvailable;			// 0x271010
	uint16				wVehicleCount;				// 0x271012
	uint16				wPersonCount;				// 0x271014
	uint16				wFlyerCount;				// 0x271016
	uint16				wTrashCount;				// 0x271018
	uint16				wOversizedCount;			// 0x27101A
	uint8				unknown_02[8];
	uint32				dwCash;						// 0x271024
	uint32				dwLoan;						// 0x271028
	uint8				xGameFlags[4];				// 0x27102C
	uint16				wParkEntryFee;				// 0x271030
	uint8				unknown_03[1114];
	uint16				wPeepCount;					// 0x27148C
	uint8				unknown_04[1130];
	uint16				wParkRating;				// 0x2718F8
	uint8				unknown_05[1086];
	uint32				dwMaxLoan;					// 0x271D38
	uint16				wPeepCash;					// 0x271D3C
	uint8				unknown_06[1742];
	uint32				dwCashCRC1;					// 0x27240C
	uint8				unknown_07[48];
	uint32				dwCashCRC2;					// 0x272440
	uint8				unknown_08[56];
	uint8				xMapXDim;					// 0x27247C
	uint8				xMapYDim;					// 0x27247D
	uint8				unknown_09[2516];
	Text				szScenarioName[64];			// 0x272E52
	Text				szScenarioDetails[256];		// 0x272E92
	uint8				xInterestRate;				// 0x272F92
	uint8				unknown_10[35657];	
	Text				szStrings[83][32];			// 0x27BADC
	uint8				unknown_11[4];
	SV6Ride				rides[kRideCount];			// 0x27C540
	}	SV6Data;

typedef SV6Data *		SV6DataPtr;

#pragma pack(pop)
/*	----------------------------------------------------------------------
	CSV6Data Class -- see SV6Data.cpp for implementation
	----------------------------------------------------------------------	*/
class CSV6Data : public Chunk
	{
/*
**	Variables
*/
protected:
	SV6DataPtr			m_pData;
	uint32				m_dwRides,
						m_dwSprites;
/*
**	Methods
*/
protected:
	uint32				computeCRC1(void) const;
	uint32				computeCRC2(void) const;

	void				dumpChain(Options const &, uint16, uint32, TextPtr) const;

	bool				getStatusBit(int32) const;
	bool				setStatusBit(int32, bool);

	bool				setCash(uint32);
	bool				setIntRate(uint8);
	bool				setLoan(uint32);
	bool				setMaxLoan(uint32);
	bool				setParkRating(uint16);
	bool				setPeepCash(uint32);

	bool				verifyChain(uint16, uint16, const CSV6Sprite::SpriteType) const;
public:
	bool				Apply(Changes const &);
	void				Dump(Options const &) const;
	bool				Read(int32, uint8 const *, uint32, uint32 &);
//
//	GETTERS/SETTERS
//
	static uint32		GetRideCount(void)
							{ return kRideCount; }
	static uint32		GetSpriteCount(void)
							{ return kSpriteCount; }

	SV6RidePtr			GetNthRide(uint32 dwx) const
							{ return (GOOD_PTR(m_pData) && dwx < kRideCount) ? &m_pData->rides[dwx] : NULL; }
	SV6SpritePtr		GetNthSprite(uint32 dwx) const
							{ return (GOOD_PTR(m_pData) && dwx < kSpriteCount) ? &m_pData->sprites[dwx] : NULL; }

	uint32				GetCash(void) const
							{ return m_pData->dwCash; }
	uint8				GetIntRate(void) const
							{ return m_pData->xInterestRate; }
	uint32				GetLoan(void) const
							{ return m_pData->dwLoan; }
	uint16				GetMapXDim(void) const
							{ return m_pData->xMapXDim; }
	uint16				GetMapYDim(void) const
							{ return m_pData->xMapXDim; }
	uint32				GetMaxLoan(void) const
							{ return m_pData->dwMaxLoan; }
	uint16				GetParkRating(void) const
							{ return m_pData->wParkRating; }
	uint16				GetPeepCount(void) const
							{ return m_pData->wPeepCount; }
	TextPtr				GetScenarioName(void) const
							{ return m_pData->szScenarioName; }
	TextPtr				GetScenarioDetails(void) const
							{ return m_pData->szScenarioDetails; }
//
//	CTOR/DTOR
//
						CSV6Data();
	virtual				~CSV6Data();
	};

#endif	// __H_SV6DATA
/****************************************************************************
**
**	End of SV6Data.h
**
****************************************************************************/
