/****************************************************************************
**
**	File Name   : SV6Header.cpp
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Implementation of the Chunk class.
**
**	Change Log	: $Header: /rctsgm/src/SV6Header.cpp 3     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Tue 04 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#include "rctsgm.h"
#include "rctfile.h"

#undef	THIS_FILE
const TextPtr			THIS_FILE = __FILE__;
/*	----------------------------------------------------------------------
	Global Constants/Variables
	----------------------------------------------------------------------	*/

/*	----------------------------------------------------------------------
	Local Function Prototypes
	----------------------------------------------------------------------	*/

/****************************************************************************
**
**	CSV6Header::CSV6Header() -- [CTOR]
**
*/
CSV6Header::CSV6Header() :	m_pHeader(NULL)
{
ASSERT( sizeof(SV6Header) == 32 );
}	/* end of CSV6Header::CSV6Header() */
/****************************************************************************
**
**	CSV6Header::~CSV6Header() -- [DTOR]
**
*/
CSV6Header::~CSV6Header()
{
m_pHeader = NULL;	// don't free it, because it really points to m_pRawData
}	/* end of CSV6Header::~CSV6Header() */
/****************************************************************************
**
**	CSV6Header::Apply() -- apply changes to this chunk
**
*/
bool							// true if changes made, false otherwise
CSV6Header::Apply(	
	Changes const &		ch)		// contains all changes to be applied
{
if (NULL_PTR(m_pHeader))
	return false;
//
//	Make a copy of the flags data
//
SV6Header	headerSave = *m_pHeader;
//
//	Set the signature
//
if (ch.bFix && m_pHeader->dwSignature != 0x00031144)
	{
	m_pHeader->dwSignature = 0x00031144;
	Display(true, 
			"FIXED: set signature in Chunk #%ld to 0x%08lX\n",
			m_nIndex, m_pHeader->dwSignature);
	}
//
//	Compare the saved copy to the current version...if there are any changes
//	then the header has been changed and is "dirty".
//
return MEM_CMP(m_pHeader, &headerSave, sizeof(SV6Header)) ? true : false;
}	/* end of CSV6Flags::Apply() */
/****************************************************************************
**
**	CSV6Header::Read() -- reads in a chunk of RCT data
**
*/
bool							// true if read successfully, false otherwise
CSV6Header::Read(
	int32			nIndex,		// chunk #
	DataPtr			pData,		// ptr to start of chunk
	uint32			dwDataLen,	// data bytes available
	uint32 &		dwRead)		// [out] size of chunk
{
m_nIndex = nIndex;		ASSERT(nIndex == 0);
	
if (!readChunk(pData, dwDataLen, dwRead))
	return false;

if (m_dwDataLen != sizeof(SV6Header))
	{
	Display(true,
			"Chunk #%d: invalid header length (%s bytes).\n",
			m_nIndex, StrNum(m_dwDataLen));
	return false;
	}
//
//	Now validate the header information.  The signature is detailed at the
//	Technical Information Depot as being 0x00031144, but the UK version 
//	evidently uses 0x00031148.  Make a signature mismatch a non-fatal warning.
//
m_pHeader = reinterpret_cast<SV6HeaderPtr>( m_pRawData );

PANIC_IF_NULL(m_pHeader);

if (m_pHeader->wFileType != 0x0000 ||		// .SV6 = 0x0000 .SC6 == 0x0001
	m_pHeader->dwVersion != 120001)
	{
	Display(true,
			"Chunk #%d: invalid header. Is this really an .SV6 file?\n",
			m_nIndex);
	return false;
	}

if (!(m_pHeader->dwSignature == 0x00031144 ||
	  m_pHeader->dwSignature == 0x00031148))
	{
	Display(true,
			"WARNING: Chunk #%d has an invalid signature (0x%08lX)\n",
			m_nIndex, m_pHeader->dwSignature);
	}

return true;
}	/* end of CSV6Header::Read() */
/****************************************************************************
**
**	End of SV6Header.cpp
**
****************************************************************************/
