/****************************************************************************
**
**	File Name   : SV6Header.h
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Class interface to the CSV6Header class
**						
**
**	Change Log	: $Header: /rctsgm/inc/SV6Header.h 3     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 ========	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#ifndef	__H_SV6HEADER
	#define __H_SV6HEADER

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif

#include "SV6Chunk.h"
/*	----------------------------------------------------------------------
	RCT2 Data Constants/Structures
	----------------------------------------------------------------------	*/
#pragma pack(push, 1)

typedef struct
	{
	uint16		wFileType;
	uint16		wCustomObj;
	uint32		dwVersion;
	uint32		dwSignature;
	uint8		unknown[20];
	}	SV6Header;

typedef SV6Header *		SV6HeaderPtr;

#pragma pack(pop)
/*	----------------------------------------------------------------------
	SV6Header Class Interface -- see SV6Header.cpp for implementation
	----------------------------------------------------------------------	*/
class CSV6Header : public Chunk
	{
/*
**	Variables
*/
protected:
	SV6HeaderPtr		m_pHeader;
/*
**	Methods
*/
public:
	bool				Apply(Changes const &);
	bool				Read(int32, DataPtr, uint32, uint32 &);
//
//	GETTERS/SETTERS
//
	uint16				GetCustomObjectCount(void) const
							{ 
							return GOOD_PTR(m_pHeader) ? m_pHeader->wCustomObj : 0;
							}
//
//	CTOR/DTOR
//
						CSV6Header();
	virtual				~CSV6Header();
	};

#endif	// __H_SV6HEADER
/****************************************************************************
**
**	End of SV6Header.h
**
****************************************************************************/
