/****************************************************************************
**
**	File Name   : SV6Ride.h
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Class interface to the CSV6Ride class, which is a wrapper
**					around one instance of the SV6Ride structure.  The data
**					is not actually stored in the class, but instead a pointer
**					to the data in the CSV6Data object is used.
**						
**
**	Change Log	: $Header: /rctsgm/inc/SV6Ride.h 7     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#ifndef	__H_SV6RIDE
	#define __H_SV6RIDE
	
#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif
/*	----------------------------------------------------------------------
	RCT2 Data Constants/Structures
	----------------------------------------------------------------------	*/
const uint8				kRideBadType	= 0xFF;
const uint32			kRideNameLen	= 32;
const uint32			kRideStations	= 4;

#pragma pack(push, 1)

typedef struct
	{
	uint8		xType;								// 0x0000
	uint8		xObjectID;							// 0x0001
	uint8		unknown_01[2];
	uint8		xOperatingMode;						// 0x0004
	uint8		xColorScheme;						// 0x0005
	uint16		wVehicleColors[32];					// 0x0006
	uint8		unknown_02[3];
	uint8		xRideStatus;						// 0x0049
	uint16		wStringIndex;						// 0x004A
	uint32		dwStringNumerator;					// 0x004C
	uint16		wFocusCoord[kRideStations + 1];		// 0x0050
	uint8		xStationData[kRideStations][4];		// 0x005A
	uint16		wEntranceCoord[kRideStations];		// 0x006A
	uint16		wExitCoord[kRideStations];			// 0x0072
	uint16		wLastGuest[kRideStations];			// 0x007A
	uint8		unknown_03[4];
	uint16		wTrainSprites[32];					// 0x0086
	uint8		xDepatureControl;					// 0x00C6
	uint8		xStationCount;						// 0x00C7
	uint8		xTrainCount;						// 0x00C8
	uint8		xCarsPerTrain;						// 0x00C9
	uint8		unknown_04[2];
	uint8		xMaxTrains;							// 0x00CC
	uint8		unknown_05[1];
	uint8		xMinWaitTime;						// 0x00CE
	uint8		xMaxWaitTime;						// 0x00CF
	uint8		xLaunchSpeed;						// 0x00D0
	uint8		unknown_06[3];
	uint8		xDataLogIndex;						// 0x00D4
	uint8		unknown_07[99];
	uint16		wTicketPrice;						// 0x0138
	uint8		unknown_08[6];
	uint16		wExcitement;						// 0x0140
	uint16		wIntensity;							// 0x0142
	uint16		wNausea;							// 0x0144
	uint8		unknown_09[21];
	uint8		xRiderCount;						// 0x015B
	uint8		xMusicType;							// 0x015C
	uint8		unknown_10[35];
	uint16		wMonthBuilt;						// 0x0180
	uint8		unknown_11[11];
	uint8		xMechanicStatus;					// 0x018D
	uint8		unknown_12[5];
	uint8		xBreakDown;							// 0x0193
	uint8		unknown_13[2];
	uint8		xReliabilityCounter;				// 0x0196
	uint8		xReliability;						// 0x0197
	uint8		unknown_14[3];
	uint8		xTimeSinceInspection;				// 0x019B
	uint8		unknown_15[44];
	uint8		xMusicTheme;						// 0x01C8
	uint8		xStationTheme;						// 0x01C9
	uint8		unknown_16[6];
	uint8		xStatusFlags[3];					// 0x01D0
	uint8		unknown_17[45];
	uint8		xQueuedGuests[kRideStations];		// 0x0200
	uint8		unknown_18[92];
	}	SV6Ride;									// 0x0260

typedef SV6Ride *		SV6RidePtr;

#pragma pack(pop)
/*	----------------------------------------------------------------------
	CSV6Ride Class -- see SV6Ride.cpp for implementation
	----------------------------------------------------------------------	*/
class CSV6Ride : public noncopyable
	{
	friend class	CSV6Data;		// rides are stored in the data chunk
/*
**	Variables
*/
protected:
	SV6RidePtr			m_pRide;
	Text				m_szName[kRideNameLen+1];
/*
**	Methods
*/
protected:
	bool				getStatusBit(int32) const;
	bool				setStatusBit(int32, bool);
	uint8				getType(void) const
							{ 
							return GOOD_PTR(m_pRide) ? m_pRide->xType : kRideBadType; 
							}
public:
	bool				Apply(Changes const &, uint32); 
	void				Dump(Options const &, uint32) const;
//
//	INLINES
//
	bool				IsEmpty(void) const
							{ 
							return (NULL_PTR(m_pRide) || (m_pRide->xType == kRideBadType));
							}

	bool				IsShopOrStall(void) const
							{ 
							TextPtr	szShops = "\x1C\x1E\x20\\x22\x23\x24\x2D\x30";
							return STR_CHR(szShops, getType()) ? true : false;
							}
//
//	GETTERS/SETTERS
//
	bool				Set(SV6RidePtr);
//
//	CTOR/DTOR
//
						CSV6Ride();
	virtual				~CSV6Ride();
	};

#endif	// __H_SV6RIDE
/****************************************************************************
**
**	End of SV6Ride.h
**
****************************************************************************/
