/****************************************************************************
**
**	File Name   : SV6Sprite.h
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Class interface to the CSV6Sprite class, which is a wrapper
**					around one instance of the SV6Sprite structure.  The data
**					is not actually stored in the class, but instead a pointer
**					to the data in the CSV6Data object is used.
**						
**
**	Change Log	: $Header: /rctsgm/inc/SV6Sprite.h 4     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 ========	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Tue 11 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#ifndef	__H_SV6SPRITE
	#define __H_SV6SPRITE

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif
/*	----------------------------------------------------------------------
	RCT2 Data Constants/Structures
	----------------------------------------------------------------------	*/
const uint8				kSpriteBadType		= 0xFF;

#pragma pack(push, 1)

typedef struct
	{
	uint8		xType;										// 0x00
	uint8		xTrashType;									// 0x01
	uint8		unknown_01[2];
	uint16		wNextSprite;								// 0x04
	uint16		wPrevSprite;								// 0x06
	uint8		unknown_02[37];
	uint8		xGraphic;									// 0x2D
	uint8		xStaff;										// 0x2E
	uint8		unknown_03[9];
	uint8		xEnergy;									// 0x38
	uint8		xEnergyTarget;								// 0x39
	uint8		xHappiness;									// 0x3A
	uint8		xHappinessTarget;							// 0x3B
	uint8		xNausea;									// 0x3C
	uint8		xNauseaTarget;								// 0x3D
	uint8		xHunger;									// 0x3E
	uint8		xThirst;									// 0x3F
	uint8		xBathroom;									// 0x40
	uint8		unknown_04[2];
	uint8		xPreferredIntensity;						// 0x43
	uint8		xNauseaTolerance;							// 0x44
	uint8		unknown_05[13];
	uint16		wVehicleRiders[32];							// 0x52
	uint8		unknown_06[10];
	uint32		dwGuestNum;									// 0x9C
	uint32		dwCash;										// 0xA0
	uint8		unknown_07[79];
	uint8		xVandal;									// 0xF3
	uint8		unknown_08[8];
	uint32		dwPurchases;								// 0xFC
	}	SV6Sprite;

typedef SV6Sprite *		SV6SpritePtr;

#pragma pack(pop)
/*	----------------------------------------------------------------------
	CSV6Sprite Class -- see SV6Sprite.cpp for implementation
	----------------------------------------------------------------------	*/
class CSV6Sprite : public noncopyable
	{
	friend class	CSV6Data;		// rides are stored in the data chunk
public:
	typedef enum	{
					ST_VEHICLE = 0,
					ST_PERSON,
					ST_FLYER,
					ST_TRASH,
					ST_OVERSIZED
					}	SpriteType;
/*
**	Variables
*/
protected:
	SV6SpritePtr		m_pSprite;
/*
**	Methods
*/
protected:
	bool				getStatusFlag(int) const;
	TextPtr				getName(void) const;

public:
	bool				Apply(Changes const &, uint32);
	void				Dump(Options const &, uint32) const;
//
//	INLINES
//
	bool				IsEmpty(void) const
							{ 
							return (GetType() == kSpriteBadType);
							}
	bool				IsPeep(void) const
							{
							return (GetType() == ST_PERSON && m_pSprite->xStaff == 0x00);
							}
	bool				IsStaff(void) const
							{
							return (GetType() == ST_PERSON && m_pSprite->xStaff == 0x01);
							}
//
//	GETTERS/SETTERS
//
	uint16				GetNext(void) const
							{ 
							return GOOD_PTR(m_pSprite) ? m_pSprite->wNextSprite : 0xFFFF; 
							}
	uint8			GetType(void) const
							{
							return GOOD_PTR(m_pSprite) ? m_pSprite->xType : kSpriteBadType; 
							}

	bool				Set(SV6SpritePtr pr)
							{ 
							m_pSprite = ::IsBadWritePtr(pr, sizeof(SV6Sprite)) ? NULL : pr;
							return GOOD_PTR(m_pSprite);
							}
//
//	CTOR/DTOR
//
						CSV6Sprite();
	virtual				~CSV6Sprite();
	};

#endif	// __H_SV6SPRITE
/****************************************************************************
**
**	End of SV6Sprite.h
**
****************************************************************************/
