/****************************************************************************
**
**	File Name   : rctfile.cpp
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Implementation of the RCTFile class.
**
**	Change Log	: $Header: /rctsgm/src/rctfile.cpp 4     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Tue 04 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#include "rctsgm.h"
#include "rctfile.h"

#undef	THIS_FILE
const TextPtr		THIS_FILE = __FILE__;
/*	----------------------------------------------------------------------
	Global Constants/Variables
	----------------------------------------------------------------------	*/

/*	----------------------------------------------------------------------
	Local Function Prototypes
	----------------------------------------------------------------------	*/

/****************************************************************************
**
**	RCTFile::RCTFile() -- [CTOR]
**
*/
RCTFile::RCTFile() :	m_dwFileBytes(0)
{
MEM_ZERO(m_szFile, sizeof(m_szFile));
}	/* end of RCTFile::RCTFile() */
/****************************************************************************
**
**	RCTFile::~RCTFile() -- [DTOR]
**
*/
RCTFile::~RCTFile()
{
// STUB FUNCTION
}	/* end of RCTFile::~RCTFile() */
/****************************************************************************
**
**	RCTFile::Close() -- close the file
**
*/
void
RCTFile::Close(void)
{
m_chunk_0.Destroy();
m_chunk_1.Destroy();
m_chunk_2.Destroy();
m_chunk_3.Destroy();
m_chunk_4.Destroy();
m_chunk_5.Destroy();
}	/* end of RCTFile::Close() */
/****************************************************************************
**
**	RCTFile::IsValidDate() -- validates a date
**
*/
bool							// true if valid, false otherwise
RCTFile::ConvertAbsMonth(
	uint16		wMonth,			// absolute month (1 is Mar-01)
	int32 &		nMonth,			// [out] month
	int32 &		nYear)			// [out] year
{
nMonth	= (wMonth & 0x07) + 3;
nYear	= (wMonth >> 3) + 1;

return CSV6Flags::IsValidDate(1, nMonth, nYear);
}	/* end of RCTFile:ConvertAbsMonth() */
/****************************************************************************
**
**	RCTFile::Open() -- opens the file
**
*/
bool
RCTFile::Open(
	TextPtr					pstrPath,
	WIN32_FIND_DATA const &	wfd)
{
uint32		dwErr = NO_ERROR;
FILE *		pfIn = NULL;
uint8 *		pFileData = NULL;

m_dwFileBytes = 0L;
MEM_ZERO(m_szFile, sizeof(Text) * (MAX_PATH + 1));
STR_COPY(m_szFile, pstrPath, MAX_PATH);
STR_CAT(m_szFile, wfd.cFileName, MAX_PATH);
//
//	Check the file size
//
if (wfd.nFileSizeLow > LONG_MAX || 
	(wfd.nFileSizeHigh > 0 && wfd.nFileSizeHigh != INVALID_FILE_SIZE))
	{
	Display(true, 
		"Failed to read file \"%s\": file is too large.\n", 
		m_szFile);
	return false;
	}

if (wfd.nFileSizeLow < (sizeof(SV6ChunkInfo) + sizeof(uint32)))
	{
	Display(true, 
		"Failed to read file \"%s\": file is too small.\n", 
		m_szFile);
	return false;
	}
//
//	Try to allocate the memory for the file
//
pFileData = new uint8[wfd.nFileSizeLow];
if (NULL_PTR(pFileData))
	{
	Display(true, 
		"Failed to read file \"%s\": could not allocate %s byte buffer.\n", 
		m_szFile, StrNum(wfd.nFileSizeLow));

	return false;
	}

m_dwFileBytes = wfd.nFileSizeLow;

try
	{
	pfIn = fopen(m_szFile, "rb");	// open as READ-ONLY
	if (NULL_PTR(pfIn))
		{
		Display(true, 
			"Failed to open file \"%s\": I/O error #%lu.\n", 
			m_szFile, errno);

		throw uint32( errno );
		}

	if (fread(pFileData, 1, m_dwFileBytes, pfIn) != m_dwFileBytes)
		{
		Display(true, 
			"Failed to read file \"%s\": I/O error #%lu.\n", 
			m_szFile, errno);

		throw uint32( errno );
		}
	//
	//	Read in chunk #0 (the header chunk)
	//
	uint32	dwChunk,
			dwOffset = 0;

	if (!m_chunk_0.Read(0, &pFileData[dwOffset], m_dwFileBytes, dwChunk))
		throw uint32( ERROR_INVALID_DATA );

	dwOffset += dwChunk;
	//
	//	Read in chunk #1 (the object chunk)
	//
	if (!m_chunk_1.Read(1, GetCustomObjectCount(), 
						&pFileData[dwOffset], (m_dwFileBytes - dwOffset), dwChunk))
		throw uint32( ERROR_INVALID_DATA );

	dwOffset += dwChunk;
	//
	//	Read in chunk #2 (the items chunk)
	//
	if (!m_chunk_2.Read(2, &pFileData[dwOffset], (m_dwFileBytes - dwOffset), dwChunk))
		throw uint32( ERROR_INVALID_DATA );

	dwOffset += dwChunk;
	//
	//	Read in chunk #3 (the flags chunk)
	//
	if (!m_chunk_3.Read(3, &pFileData[dwOffset], (m_dwFileBytes - dwOffset), dwChunk))
		throw uint32( ERROR_INVALID_DATA );

	dwOffset += dwChunk;
	//
	//	Read in chunk #4 (the map chunk)
	//
	if (!m_chunk_4.Read(4, &pFileData[dwOffset], (m_dwFileBytes - dwOffset), dwChunk))
		throw uint32( ERROR_INVALID_DATA );

	dwOffset += dwChunk;
	//
	//	Read in chunk #5 (the data chunk)
	//
	if (!m_chunk_5.Read(5, &pFileData[dwOffset], (m_dwFileBytes - dwOffset), dwChunk))
		throw uint32( ERROR_INVALID_DATA );

	dwOffset += dwChunk;
	/*
	**	Check the CRC using a really simplistic accumlator process, and also
	**	make sure there isn't any extra data hanging around the end of the file.
	*/
	uint32		dwCRC = 0L,
				dwCRCOffset = m_dwFileBytes - sizeof(uint32);
	uint32 *	pdwCRC = MAKE_PTR(uint32 *, pFileData, dwCRCOffset);

	if (dwOffset == dwCRCOffset)
		Display(false, "File length OK\n");
	else
		Display(true, "WARNING: file length is incorrect!\n");

	for (uint32 dwx = 0; dwx < dwCRCOffset; ++dwx)
		dwCRC += pFileData[dwx];

	if (dwCRC == *pdwCRC)
		Display(false, "File CRC OK\n");
	else
		Display(true, "WARNING: file CRC does not match!\n");

	dwErr = NO_ERROR;
	}
catch (uint32 dwErrThrown)
	{
	dwErr = dwErrThrown;
	}

if (GOOD_PTR(pFileData))
	{
	delete [] pFileData;
	pFileData = NULL;
	}

if (GOOD_PTR(pfIn))
	{
	(void) fclose(pfIn);
	pfIn = NULL;
	}

return (dwErr == NO_ERROR);
}	/* end of RCTFile::Open() */
/****************************************************************************
**
**	RCTFile::Write() -- write the file back out again
**
*/
bool
RCTFile::Write(
	TextPtr		pstrFile)
{
FILE *	pfNew = NULL;
uint32	dwCRC = 0L,
		dwErr = NO_ERROR;

m_dwFileBytes = 0L;
MEM_ZERO(m_szFile, sizeof(Text) * (MAX_PATH + 1));
STR_COPY(m_szFile, pstrFile, MAX_PATH);

try
	{
	pfNew = fopen(pstrFile, "w+b");
	if (NULL_PTR(pfNew))
		throw uint32( errno );

	if (m_chunk_0.Write(pfNew, m_dwFileBytes, dwCRC) &&
		m_chunk_1.Write(pfNew, m_dwFileBytes, dwCRC) &&
		m_chunk_2.Write(pfNew, m_dwFileBytes, dwCRC) &&
		m_chunk_3.Write(pfNew, m_dwFileBytes, dwCRC) &&
		m_chunk_4.Write(pfNew, m_dwFileBytes, dwCRC) &&
		m_chunk_5.Write(pfNew, m_dwFileBytes, dwCRC))
		{
		if (fwrite(&dwCRC, 1, sizeof(uint32), pfNew) != sizeof(uint32))
			throw uint32( errno );

		m_dwFileBytes += sizeof(uint32);
		Display(false,
				"File CRC is 0x%08lX\n",
				dwCRC);
		}
	}
catch (uint32 dwErrThrown)
	{
	dwErr = dwErrThrown;
	Display(true, 
			"Could not create file \"%s\" (error #%lu).\n", 
			pstrFile, dwErr);

	ASSERT(dwErr != NO_ERROR);
	}

if (GOOD_PTR(pfNew))
	(void) fclose(pfNew);

return (dwErr == NO_ERROR);
}	/* end of RCTFile::Write() */
/****************************************************************************
**
**	End of rctfile.cpp
**
****************************************************************************/
