/****************************************************************************
**
**	File Name   : SV6Flags.h
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Class interface to the SV6Flags class.
**						
**
**	Change Log	: $Header: /rctsgm/inc/SV6Flags.h 3     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 ========	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#ifndef	__H_SV6FLAGS
	#define __H_SV6FLAGS

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif

#include "SV6Chunk.h"
/*	----------------------------------------------------------------------
	RCT2 Data Constants/Structures
	----------------------------------------------------------------------	*/
const int32				kMaxMonth		= 10;
const int32				kMinMonth		= 3;

const int32				kMaxYear		= 99;
const int32				kMinYear		= 1;
/*
**	SV6Flags -- this data structure must match the data structure stored in
**	the data file.
*/
#pragma pack(push, 1)

typedef struct
	{
	uint16		wAbsMonth;
	uint16		wDay;
	uint8		unknown[12];
	}	SV6Flags;

typedef SV6Flags *		SV6FlagsPtr;

#pragma pack(pop)
/*	----------------------------------------------------------------------
	CSV6Flags Class -- see SV6Flags.cpp for implementation
	----------------------------------------------------------------------	*/
class CSV6Flags : public Chunk
	{
/*
**	Variables
*/
protected:
	SV6FlagsPtr			m_pFlags;
/*
**	Methods
*/
protected:
	bool				setDate(int32, int32, int32);
public:
	bool				Apply(Changes const &);
	void				Dump(Options const &) const;
	bool				Read(int32, DataPtr, uint32, uint32 &);

	static bool			IsValidDate(int32, int32, int32);
//
//	GETTERS/SETTERS
//
	uint16				GetAbsMonth(void) const
							{ return m_pFlags->wAbsMonth; }
	int32				GetDay(void) const
							{ return ((m_pFlags->wDay << 4) / 0x8421) + 1; }
	int32				GetMonth(void) const
							{ return (GetAbsMonth() & 0x07) + 3; }
	int32				GetYear(void) const
							{ return (GetAbsMonth() >> 3) + 1; }
//
//	CTOR/DTOR
//
						CSV6Flags();
	virtual				~CSV6Flags();
	};

#endif	// __H_SV6FLAGS
/****************************************************************************
**
**	End of SV6Flags.h
**
****************************************************************************/
