/****************************************************************************
**
**	File Name   : SV6Map.h
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Class interface to the CSV6Map class.
**						
**
**	Change Log	: $Header: /rctsgm/inc/SV6Map.h 4     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Wed 12 Mar '03		1.01	Mode code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --expandcode flag and logic
**
****************************************************************************/
#ifndef	__H_SV6MAP
	#define __H_SV6MAP

#if defined(_MSC_VER) && (_MSC_VER >= 1020)
#	pragma once
#endif

#include "SV6Chunk.h"
/*	----------------------------------------------------------------------
	RCT2 Data Constants/Structures
	----------------------------------------------------------------------	*/
/*
**	SV6MapEntry -- this data structure must match the data structure stored in
**	the data file.
*/
#pragma pack(push, 1)

typedef struct
	{
	uint8		xData[8];
	}	SV6MapEntry;

typedef SV6MapEntry *	SV6MapEntryPtr;

#pragma pack(pop)
/*	----------------------------------------------------------------------
	CSV6Map Class -- see SV6Items.cpp for implementation
	----------------------------------------------------------------------	*/
class CSV6Map : public Chunk
	{
/*
**	Variables
*/
protected:
	SV6MapEntryPtr		m_pMap;
	uint32				m_dwMapEntries;
/*
**	Methods
*/
public:
	bool				Apply(Changes const &);
	void				Dump(Options const &) const;
	bool				Read(int32, DataPtr, uint32, uint32 &);
//
//	GETTERS/SETTERS
//
	uint32				GetMapEntries(void) const
							{ return m_dwMapEntries; }
//
//	CTOR/DTOR
//
						CSV6Map();
	virtual				~CSV6Map();
	};

#endif	// __H_SV6MAP
/****************************************************************************
**
**	End of SV6Map.h
**
****************************************************************************/
