/****************************************************************************
**
**	File Name   : SV6Objects.cpp
**
**	Project     : RCTSGM
**
**	Last Updated: Tue 27 May '03
**	          by: ,,,^..^,,,
**
**	Description : Implementation of the CSV6Objects class.
**
**	Change Log	: $Header: /rctsgm/src/SV6Objects.cpp 4     5/27/03 4:13p Neusel $
**
**		Date		 Version	Reason
**		====		 =======	======
**	Thu 06 Mar '03		1.00	Initial design & coding
**	Mon 10 Mar '03		1.01	Made code more portable (less Win32 stuff)
**	Tue 27 May '03		1.02	Added --fix flag and logic
**
****************************************************************************/
#include "rctsgm.h"
#include "rctfile.h"

#undef	THIS_FILE
const TextPtr			THIS_FILE = __FILE__;
/*	----------------------------------------------------------------------
	Global (external) Constants/Variables
	----------------------------------------------------------------------	*/

/*	----------------------------------------------------------------------
	Local (static) Constants/Variables
	----------------------------------------------------------------------	*/
static Text				s_szName[kSV6ObjectNameLen+1] = { 0 };
/*	----------------------------------------------------------------------
	Local Function Prototypes
	----------------------------------------------------------------------	*/
static TextPtr			getName(SV6ObjHeader const &);
/****************************************************************************
**
**	CSV6Objects::CSV6Objects() -- [CTOR]
**
*/
CSV6Objects::CSV6Objects() : m_wObjCount(0)
{
ASSERT( sizeof(SV6ObjHeader) == 21 );
}	/* end of CSV6Objects::CSV6Objects() */
/****************************************************************************
**
**	CSV6Objects::~CSV6Objects() -- [DTOR]
**
*/
CSV6Objects::~CSV6Objects()
{
// STUB FUNCTION
}	/* end of CSV6Objects::~CSV6Objects() */
/****************************************************************************
**
**	CSV6Objects::Apply() -- apply changes to the ride information
**
*/
bool							// true if changes made, false otherwise
CSV6Objects::Apply(
	Changes const &)			// changes to apply
{
return false;
}	/* end of CSV6Objects::Apply() */
/****************************************************************************
**
**	CSV6Objects::Dump() -- dumps all object information
**
*/
void
CSV6Objects::Dump(
	Options const &	opt) const
{
if (m_wObjCount == 0)
	{
	Display(opt.bDumpObjects, "No objects\n");
	return;
	}

PANIC_IF_NULL(m_pRawData);
//
//	Walk the object data, dumping each one as we go
//
SV6ObjHeader	objHeader;
uint32			dwOffset = 0;

Display(opt.bDumpObjects,
		"Obj#    Name     Bytes\n"
		"=======================\n");

for (uint16 wObj = 0; wObj < m_wObjCount; ++wObj)
	{
	if ((dwOffset + sizeof(SV6ObjHeader)) > m_dwDataLen)
		{
		Display(true,
				"Chunk %ld object #%d: invalid offset.\n",
				m_nIndex, wObj);

		throw uint32(ERROR_INVALID_DATA);
		}

	MEM_COPY(&objHeader, &m_pRawData[dwOffset], sizeof(SV6ObjHeader));

	ASSERT(objHeader.chunk.dwChunkSize > 0);
	ASSERT((dwOffset + objHeader.chunk.dwChunkSize) <= m_dwDataLen);

	dwOffset += sizeof(SV6ObjHeader) + objHeader.chunk.dwChunkSize;
	//
	//	Now dump the object information
	//
	Display(opt.bDumpObjects,
			"%4d '%-8s' %7s\n",
			wObj, getName(objHeader), StrNum(objHeader.chunk.dwChunkSize));
	}

Display(opt.bDumpObjects, 
		"=======================\n"
		"%4d objects %10s bytes\n\n",
		m_wObjCount, StrNum(m_dwDataLen));
}	/* end of CSV6Objects::Dump() */
/****************************************************************************
**
**	CSV6Objects::Read() -- reads in a chunk of RCT data
**
*/
bool							// true if read successfully, false otherwise
CSV6Objects::Read(
	int32		nIndex,			// chunk #
	uint16		wObjects,		// count of objects
	DataPtr		pData,			// ptr to start of chunk
	uint32		dwDataLen,		// data bytes available
	uint32 &	dwRead)			// [out] size of chunk
{
m_nIndex = nIndex;		ASSERT(nIndex == 1);

m_wObjCount = wObjects;

dwRead = 0;
	
if (m_wObjCount == 0)
	return true;
//
//	Parse the object to figure out how many there are, and how much space they
//	take up in the file.
//
SV6ObjHeader	objHeader;

for (uint16 wObj = 0; wObj < m_wObjCount; ++wObj)
	{
	if ((dwRead + sizeof(SV6ObjHeader)) > dwDataLen)
		{
		Display(true,
				"Chunk %ld object #%d: not enough data\n",
				m_nIndex, wObj);
		return false;
		}

	MEM_COPY(&objHeader, &pData[dwRead], sizeof(SV6ObjHeader));
	if (objHeader.chunk.dwChunkSize == 0 ||
		(dwRead + objHeader.chunk.dwChunkSize) > dwDataLen)
		{
		Display(true,
				"Chunk %ld object #%d: invalid data length (%s bytes)\n",
				m_nIndex, wObj, StrNum(objHeader.chunk.dwChunkSize));
		return false;
		}

	dwRead += sizeof(SV6ObjHeader) + objHeader.chunk.dwChunkSize;
	}
//
//	Allocate a buffer and copy the raw (compressed) object data into it.
//
allocateData(dwRead);
MEM_COPY(m_pRawData, pData, dwRead);	//lint !e585 !e668

return true;
}	/* end of CSV6Objects::Read() */
/****************************************************************************
**
**	CSV6Objects::Write() -- write out the raw (compressed) object data
**
*/
bool							// true if written, false otherwise
CSV6Objects::Write(
	FILE *		pfOut,			// handle to output file
	uint32 &	dwBytes,		// running count of bytes written
	uint32 &	dwCRC)			// CRC value (simple accumulator)
{
if (GOOD_PTR(pfOut) &&
	GOOD_PTR(m_pRawData) &&
	m_wObjCount > 0 &&
	m_dwDataLen > 0)
	{
	uint8 *		pData;
	uint32		dwActual,
				dwWanted;
	//
	//	Write out the raw data
	//
	pData = m_pRawData; 
	dwWanted = m_dwDataLen;
	dwActual = uint32( fwrite(pData, 1, dwWanted, pfOut) );
	if (dwWanted != dwActual)
		return false;

	dwBytes += dwActual;
	for (dwWanted = 0; dwWanted < dwActual; ++dwWanted)
		dwCRC += *pData++;

	Display(false,
			"Chunk #%d: wrote out %s bytes\n",
			m_nIndex, StrNum(dwActual));
	}

return true;
}	/* end of CSV6Objects::Write() */
/****************************************************************************
**
**	getName() -- [STATIC] converts a header name to a null-terminated string.
**
*/
static TextPtr
getName(SV6ObjHeader const &	header)
{
MEM_COPY(s_szName, header.xName, kSV6ObjectNameLen);

return s_szName;
}	/* end of getName() */
/****************************************************************************
**
**	End of SV6Objects.cpp
**
****************************************************************************/
